// SPDX-License-Identifier: GPL-2.0
#include <linux/printk.h>
#include <linux/sched.h>
#include <linux/task.h>
#include <linux/init.h>
#include <linux/kernel.h>

#include <rupsched/avr232.h>

#include <asm/system.h>
#include <asm/io.h>



extern void dump_memory(void);

void usart_thread(void *arg) {
	char ch;
	int ch_num;

	printk(KERN_NOTICE "Hello World from task!\n");
	printk(KERN_NOTICE "arg=%x\n", arg);
	printk(KERN_NOTICE "sp=%x\n", in_16(SP));
	
	for (;;) {
		ch_num = avr232_getc();
		if (ch_num < 0) {
			continue;
		}
		ch = ch_num;
#ifdef CONFIG_PANIC
		if (ch == 'D') {
			dump_memory();
			continue;
		}
		if (ch == 'P') {
			panic("test");
		}
#endif
		avr232_putc(ch);
		if (ch == '\r') {
			ch = '\n';
			avr232_putc('\n');
#ifdef CONFIG_STACK_SIZE_REPORTING
			report_stack_usage();
#endif
		}
	}
}

#ifdef CONFIG_STACK_SIZE_FIXED
static struct task_struct usart_task;
#endif

static int init_usart_test(void) {
	printk(KERN_NOTICE "\n\n\nHello World from init!\n");
#ifdef CONFIG_STACK_SIZE_FIXED
	kernel_thread(&usart_task, usart_thread, (void*)0x1234, 1);
#else
	kernel_thread(128, usart_thread, (void*)0x1234, 1);
#endif
	return 0;
}

initcall(init_usart_test);
