// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2010, 2017-2019 Rupert Eibauer. All rights reserved.

#include <linux/types.h>
#include <linux/timer.h>
#include <linux/printk.h>
#include <linux/init.h>

#include <asm/system.h>
#include <asm/gpio.h>


//#define NO_WAIT
#ifdef NO_WAIT

#define wait() do { } while(0)

#else /* NO_WAIT */
static void wait(void) {
	volatile int wait_counter;
	volatile int wait_counter2;
	for (wait_counter = 0; wait_counter < 50; wait_counter++)
	for (wait_counter2 = 0; wait_counter2 < 1000; wait_counter2++);
}
#endif /* NO_WAIT */


#define TEST_HZ 8

static struct timer test_timer0, test_timer1, test_timer2;

static void timer_callback0(struct timer *timer) {
	gpio_toggle(GPIO_C0);
#ifdef CONFIG_MOD_TIMER
	mod_timer(timer, timer->expires + HZ / TEST_HZ);
#else
	timer->expires += HZ / TEST_HZ;
	add_timer(timer);
#endif
}
static struct timer test_timer0 = {
	.function = timer_callback0,
	.expires  = HZ * 2,
};

static void timer_callback1(struct timer *timer) {
	gpio_toggle(GPIO_C1);
#ifdef CONFIG_MOD_TIMER
	mod_timer(timer, timer->expires + HZ / 4 / TEST_HZ);
#else
	timer->expires += HZ / 4 / TEST_HZ;
	add_timer(timer);
#endif
}
static struct timer test_timer1 = {
	.function = timer_callback1,
	.expires  = HZ + HZ / 4 / TEST_HZ,
};

static void timer_callback2(struct timer *timer) {
	gpio_toggle(GPIO_C2);
#ifdef CONFIG_MOD_TIMER
//	mod_timer(timer, timer->expires + HZ / 16 / TEST_HZ);
	mod_timer(timer, timer->expires + HZ / 881);
#else
	timer->expires += HZ / 881;
	add_timer(timer);
#endif
}
static struct timer test_timer2 = {
	.function = timer_callback2,
	.expires  = HZ + 1 + HZ / 881,
};

static struct timer accel_timer;
static void accel_callback(struct timer *timer) {
	static u32 delay = HZ / 10000;
	static u32 scount;

	gpio_toggle(GPIO_C2);
	scount += delay;
	
	if (scount >= HZ && delay != 0) {
		scount = 0;
		delay--;
	}
	timer->expires += delay;
	_add_timer(timer);
}
static struct timer accel_timer = {
	.function = accel_callback,
	.expires  = HZ,
};

static int init_timer_test(void) {
	int i;
	printk(KERN_NOTICE "Test starting\n");
	gpiogroup_set_output_v(GPIO_C0, GPIO_C0_NBITS, 7);
	gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, 0);
	wait();
	wait();
	wait();
	wait();
	for (i = 0; i <= 7; i++) {
		wait();
		gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, i);
	}
	wait();
	gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, 0);

	local_irq_enable();
	add_timer(&accel_timer);
//	add_timer(&test_timer2);
	add_timer(&test_timer1);
	add_timer(&test_timer0);
	printk(KERN_NOTICE "Test init done\n");

// 	for(;;) {
//	  gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, (jiffies >> 360) & 3);
// 	  wait();
// 	}
	return 0;
}

initcall(init_timer_test);
