// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2017-2019 Rupert Eibauer. All rights reserved.

#include <linux/init.h>
#include <linux/delay.h>
#include <linux/printk.h>
#include <linux/sched.h>
#include <linux/task.h>

#include <asm/system.h>
#include <asm/gpio.h>

//#define NO_WAIT
#ifdef NO_WAIT

#define wait() do { } while(0)

#else /* NO_WAIT */
#define wait() udelay(500000)
#endif /* NO_WAIT */

/* Simple completion test */
/* The result should look like the following (when watched with simulavr-disp)
   PORTC alternating between 1 and 2
*/
// #define TEST_FAKE_IRQ
#ifdef CONFIG_STACK_SIZE_FIXED
struct task_struct tw;
struct task_struct ts;
#endif

struct completion s;

#ifdef TEST_FAKE_IRQ
// void fake_irq_handler(void) __attribute__((signal));
void fake_irq_handler(void) {
	printk(KERN_NOTICE "irq\n");
	local_irq_disable();
	complete_from_irq(&s);
	resched_after_irq();
	local_irq_enable();
}
#endif


__kthread_func void fw(void *arg)
{
	printk(KERN_NOTICE "fw started\n");
	for (;;)
	{
		printk(KERN_NOTICE "fw\n");
		gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, 1);
		wait();
		wait_for_completion(&s);
	}
}

__kthread_func void fs(void *arg)
{
	printk(KERN_NOTICE "fs started\n");
	for (;;)
	{
		printk(KERN_NOTICE "fs\n");
		gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, 1);
		wait();
#ifdef TEST_FAKE_IRQ
		fake_irq_handler();
#else
		complete(&s);
#endif
	}
}

static int init_semaphore_test(void) {
	int i;

	gpiogroup_set_output_v(GPIO_C0, GPIO_C0_NBITS, 7);
	printk(KERN_NOTICE "in Main...\n");
	wait();
	wait();
	wait();
	wait();
	gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, 7);
	for (i = 0; i <= 7; i++) {
		wait();
		gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, i);
	}
	wait();
	gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, 0);

#ifdef CONFIG_STACK_SIZE_FIXED
	kernel_thread(&tw, fw, NULL, 2); /* High-prio waiter */
	kernel_thread(&ts, fs, NULL, 1); /* Low-prio signaler */
#else
	kernel_thread(128, fw, NULL, 2); /* High-prio waiter */
	kernel_thread(128, fs, NULL, 1); /* Low-prio signaler */
#endif
	gpiogroup_out(GPIO_C0, GPIO_C0_NBITS, 1);
	printk(KERN_NOTICE "calling schedule...\n");
	return 0;
}

initcall(init_semaphore_test);
