// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2018-2019 Rupert Eibauer. All rights reserved.

#include <stdarg.h>

#include <linux/types.h>
#include <linux/printk.h>
#include <linux/cdev.h>

#include <rupsched/vdevprintf.h>

extern struct ocdev kernel_console;

void printk_(__rodata char *fmt, ...) {
        va_list ap;

        va_start(ap, fmt);
        vdevprintf(fmt, &kernel_console, ap);
        va_end(ap);
}
