// SPDX-License-Identifier: GPL-2.0
#ifndef _LINUX_TASK_H
#define _LINUX_TASK_H

#include <asm/task.h>
#ifndef __ASSEMBLY__
#include <linux/jiffies.h>
#endif

#ifdef CONFIG_SCHEDULER

#ifdef __AVR__ // FIXME Move to another header
#define SIZE_POINTER 2
#else
#define SIZE_POINTER 4
#endif

#ifndef __ASSEMBLY__
struct sched_entity {
	u8 prio;
#ifdef CONFIG_TIME_SLICES
	u8 timeSlice;
#endif
#ifdef CONFIG_SCHED_OTHER
	u8 weight;
	s16 bonus;
	struct task_struct *next_other; /* This list is used for bonus distribution only */
	jiffies_t exec_start;
#endif
};

struct task_struct {
#if !defined(CONFIG_STACK_SIZE_FIXED) && (defined(CONFIG_STACK_CHECK) || defined(CONFIG_STACK_SIZE_REPORTING))
	stack_size_t stack_size;
#endif
	struct task_saved_state state; // CPU-specific state
	struct task_struct *next;
	struct sched_entity entity;
#ifdef CONFIG_MUTEX_PI
	struct mutex *waitMutex; // Mutex this task is blocked by
#endif
	/* FIMXE: stack_buffer1 and stack_buffer2 needed! */
	u8 stack_guard1[CONFIG_STACK_GUARD];
#ifdef CONFIG_STACK_SIZE_FIXED
	u8 stack[CONFIG_STACK_SIZE + CONFIG_STACK_GUARD];
#else /* CONFIG_STACK_SIZE_FIXED */
	u8 stack[];
#endif /* CONFIG_STACK_SIZE_FIXED */
};
#endif /* __ASSEMBLY__ */

#endif /* CONFIG_SCHEDULER */

#endif /* _LINUX_TASK_H */
