// SPDX-License-Identifier: GPL-2.0
#ifndef _LINUX_SLAB_H
#define _LINUX_SLAB_H

#include <linux/types.h>

void kfree(const void*);
__attribute__((alloc_size(1), malloc(kfree)))
void *kmalloc(alloc_size_t size, int flags);

#define GFP_KERNEL    0

/* #define GFP_ZERO      1 */

#ifndef CONFIG_STACK_SIZE_FIXED
#ifdef CONFIG_TINY_STACK
#define GFP_KTHREAD   2
#else
#define GFP_KTHREAD   0
#endif
#endif

#endif /* _LINUX_SLAB_H */
