/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __LINUX_SCHED_H
#define __LINUX_SCHED_H

#include <linux/types.h>

#define CONFIG_KTHREAD_ARG
// #define CONFIG_END_TASK

#ifdef CONFIG_SCHEDULER

struct task_struct;

#ifdef CONFIG_STACK_SIZE_FIXED

// create task & add to task-list
struct task_struct *kernel_thread(struct task_struct *task, void (*f)(void *arg), void *arg, signed char prio);

#else /* CONFIG_STACK_SIZE_FIXED */

// create task & add to task-list
struct task_struct *kernel_thread(stack_size_t stack_size, void (*f)(void*), void *arg, signed char prio);

#endif /* CONFIG_STACK_SIZE_FIXED */

/* internal function to set-up the kickstart of the task. */
void setup_task(struct task_struct *task, void (*f)(void *arg), void *arg, stack_size_t stack_size);

// if called from the main thread it starts the scheduler
// if called from another thread it will be stopped.
// the scheduler will simply forget about current as 
// soon as it finds another task to run.
void kill_current(void) __attribute((noreturn));

#ifdef CONFIG_USE_SEMA
struct completion {
	struct task_struct *waitTask;
	signed char done;
};

void complete(struct completion *s);
void wait_for_completion(struct completion *s);
static inline void init_completion(struct completion *s) {
	s->done = 0;
}

#endif

#ifdef CONFIG_USE_MUTEX
struct mutex {
	struct task_struct *owner;
#ifdef CONFIG_MUTEX_PI
	u8 origPrio;
#endif
	struct task_struct *waiters;
};

void mutex_lock(struct mutex *mutex);
void mutex_unlock(struct mutex *mutex);
#endif

#ifdef CONFIG_USE_CHANGE_PRIO
void taskChangePrio(struct task_struct *task, u8 prio);
#endif

#endif /* CONFIG_SCHEDULER */

#ifdef CONFIG_WAKE_SEMA_FROM_IRQ
void complete_from_irq(struct completion *s);
void resched_after_irq(void);
#else
#define resched_after_irq() do{}while(0)
#endif

#define cond_resched() do{}while(0)

extern struct task_struct *current;

#ifdef CONFIG_STACK_SIZE_REPORTING
void report_stack_usage(void);
#endif

#ifdef CONFIG_STACK_CHECK

#define check_thread_stack(t) _check_thread_stack(t, __builtin_return_address(0), __LINE__)
#define check_thread_stack2(t, line) _check_thread_stack(t, __builtin_return_address(0), line + __LINE__)
extern void _check_thread_stack(struct task_struct *task, void *ret, u16 line);

#else /* CONFIG_STACK_CHECK */

#define check_thread_stack(t) do{}while(0)
#define check_thread_stack2(t, line) do{}while(0)

#endif /* CONFIG_STACK_CHECK */


#endif /* __LINUX_SCHED_H */
