/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_KERN_LEVELS_H
#define _LINUX_KERN_LEVELS_H

#define KERN_EMERG          1,  /* system is unusable */
#define KERN_ALERT          2,  /* action must be taken immediately */
#define KERN_CRIT           3,  /* critical conditions */
#define KERN_ERR            4,  /* error conditions */
#define KERN_WARNING        5,  /* warning conditions */
#define KERN_NOTICE         6,  /* normal but significant condition */
#define KERN_INFO           7,  /* informational */
#define KERN_DEBUG          8,  /* debug-level messages */

#ifndef CONFIG_PRINTK_LEVEL
#define KERN_LOGLEVEL 6
// #warning change kconfig
#else
#error
#define KERN_LOGLEVEL CONFIG_PRINTK_LEVEL
#endif

#define KERN_CONT       ,  /* don't need to copy any bullshit. */

#endif /* _LINUX_KERN_LEVELS_H */
