// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2018-2019 Rupert Eibauer. All rights reserved.

#include <linux/sched.h>
#include <linux/task.h>
#include <linux/printk.h>
#include "saved-regs-counter.h"

#ifdef CONFIG_KTHREAD_ARG
/* Jumping a task is easy.*/
__attribute__((naked))
static void kick_task(void) {
	asm volatile (
		"pop r25\n\t"
		"pop r24\n\t"
		"reti\n\t"
	);
}
#endif


/* FIXME: All this inline assembly is required because the compiler is too stupid
 * to optimize *--stack = ...
 * */
#define REG "+x"

#define dec_store(ptr, data) do { \
        asm ( \
                "st -%a0, %1" \
                : REG (ptr) \
                : "r" ((u8)data) \
                : "memory" \
        ); \
} while(0)
#define dec_clear(ptr) do { \
        asm ( \
                "st -%a0, __zero_reg__" \
                : REG (ptr) \
                : \
                : "memory" \
        ); \
} while(0)
#define dec_store2(ptr, data) do { \
        asm ( \
                "st -%a0, %A1\n\t" \
                "st -%a0, %B1" \
                : REG (ptr) \
                : "r" (data) \
                : "memory" \
        ); \
} while(0)

/* This function prepares a task to be started by _taskSwitchTo */
#define CLEAR_STACK

void setup_task(struct task_struct *task, void (*f)(void *arg), void *arg, stack_size_t stack_size)
{
	unsigned char *stack;
#if defined(CONFIG_STACK_GUARD) || defined(CLEAR_STACK) || defined(CONFIG_STACK_SIZE_REPORTING)
	u8 i;
#endif
 
	stack = &task->stack[stack_size];

#ifdef CONFIG_END_TASK
	/* We simply let it return to kill_current. */
	dec_store2(stack, ((uintptr_t)kill_current));
#endif
	dec_store2(stack, ((uintptr_t)f));
 
#ifdef CONFIG_KTHREAD_ARG
	dec_store2(stack, ((uintptr_t)arg));
	dec_store2(stack, ((uintptr_t)kick_task));
#endif

#ifdef CLEAR_STACK
	/* The task gets its registers initialized to 0 (Unneeded crap or useful?) poisoning may be better for debugging. */
	for (i = 0; i < NR_SAVED_REGS; i++)
		dec_clear(stack);
#else
	stack -= NR_SAVED_REGS;
#endif

#ifdef CONFIG_LARGE_SP
	task->state.L_SP = stack - 1;
	printk(KERN_DEBUG "new task=%x SP=%x\n", task, task->state.L_SP);
#else
	task->state.sp = stack - task->stack - 1;
	printk(KERN_DEBUG "new task=%x sp=%x\n", task, task->state.sp);
#endif
#ifdef CONFIG_STACK_SIZE_REPORTING
	do {
		dec_store(stack, 0xaa);
	} while (stack != task->stack);
#endif

#if CONFIG_STACK_GUARD > 0
	for (i = 0; i < CONFIG_STACK_GUARD; i++) {
		task->stack_guard1[i] = '1';
		task->stack[stack_size + i] = '2';
	}
#endif
}
