/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) 2008, 2018-2023 Rupert Eibauer. All rights reserved. */

#include <generated/asm-offsets.h>

#define PTR    Z
#define PTR_lo r30
#define PTR_hi r31

	.file	"sched.S"
__SREG__ = 0x3f
__SP_H__ = 0x3e
__SP_L__ = 0x3d
__tmp_reg__ = 0
__zero_reg__ = 1

.global	_taskSwitchTo
	.type	_taskSwitchTo, @function
_taskSwitchTo:
#ifdef CONFIG_CALL_SAVED_R31
	push r31
#endif
#ifdef CONFIG_CALL_SAVED_R30
	push r30
#endif
	lds PTR_lo,current
	lds PTR_hi,(current)+1
	sbiw PTR_lo,0 /* if current is NULL */
	breq no_regs_save  /* We skip saving regs */

#ifdef CONFIG_CALL_SAVED_R29
	push r29
#endif
#ifdef CONFIG_CALL_SAVED_R28
	push r28
#endif
#ifdef CONFIG_CALL_SAVED_R27
	push r27
#endif
#ifdef CONFIG_CALL_SAVED_R26
	push r26
#endif
#ifdef CONFIG_CALL_SAVED_R25
	push r25
#endif
#ifdef CONFIG_CALL_SAVED_R24
	push r24
#endif
#ifdef CONFIG_CALL_SAVED_R23
	push r23
#endif
#ifdef CONFIG_CALL_SAVED_R22
	push r22
#endif
#ifdef CONFIG_CALL_SAVED_R21
	push r21
#endif
#ifdef CONFIG_CALL_SAVED_R20
	push r20
#endif
#ifdef CONFIG_CALL_SAVED_R19
	push r19
#endif
#ifdef CONFIG_CALL_SAVED_R18
	push r18
#endif
#ifdef CONFIG_CALL_SAVED_R17
	push r17
#endif
#ifdef CONFIG_CALL_SAVED_R16
	push r16
#endif
#ifdef CONFIG_CALL_SAVED_R15
	push r15
#endif
#ifdef CONFIG_CALL_SAVED_R14
	push r14
#endif
#ifdef CONFIG_CALL_SAVED_R13
	push r13
#endif
#ifdef CONFIG_CALL_SAVED_R12
	push r12
#endif
#ifdef CONFIG_CALL_SAVED_R11
	push r11
#endif
#ifdef CONFIG_CALL_SAVED_R10
	push r10
#endif
#ifdef CONFIG_CALL_SAVED_R9
	push r9
#endif
#ifdef CONFIG_CALL_SAVED_R8
	push r8
#endif
#ifdef CONFIG_CALL_SAVED_R7
	push r7
#endif
#ifdef CONFIG_CALL_SAVED_R6
	push r6
#endif
#ifdef CONFIG_CALL_SAVED_R5
	push r5
#endif
#ifdef CONFIG_CALL_SAVED_R4
	push r4
#endif
#ifdef CONFIG_CALL_SAVED_R3
	push r3
#endif
#ifdef CONFIG_CALL_SAVED_R2
	push r2
#endif

/* Save the old SP */
	in r22,__SP_L__
#ifdef CONFIG_LARGE_SP
	in r23,__SP_H__
	std PTR+TASK_sp+1,r23
#else
	sub  r22,PTR_lo
	subi r22,TASK_stack
#endif
	std PTR+TASK_sp,r22

no_regs_save:
#ifdef __AVR_HAVE_MOVW__
	mov PTR_lo,r24
	mov PTR_hi,r25
#else
	movw PTR_lo,r24
#endif

/* Save the new task to current */
	sts current+1,PTR_hi
	sts current,PTR_lo

/* Load the new SP */
#ifdef CONFIG_LARGE_SP
	ldd r24,PTR+TASK_sp
	ldd r25,PTR+TASK_sp+1
#else /* CONFIG_LARGE_SP */
#ifdef __AVR_HAVE_MOVW__
	mov r24,PTR_lo
	mov r25,PTR_hi
#else
	movw r24,PTR_lo
#endif
#if TASK_stack > 63
	subi r24,lo8(-(TASK_stack))
	sbci r25,hi8(-(TASK_stack))
#else
	adiw r24, TASK_stack
#endif
	ldd r20,PTR+TASK_sp
	add r24,r20
#ifndef CONFIG_TINY_STACK
	adc r25,__zero_reg__
#endif
#endif /* CONFIG_LARGE_SP */

	out __SP_H__,r25
	out __SP_L__,r24

#ifdef CONFIG_CALL_SAVED_R2
	pop r2
#endif
#ifdef CONFIG_CALL_SAVED_R3
	pop r3
#endif
#ifdef CONFIG_CALL_SAVED_R4
	pop r4
#endif
#ifdef CONFIG_CALL_SAVED_R5
	pop r5
#endif
#ifdef CONFIG_CALL_SAVED_R6
	pop r6
#endif
#ifdef CONFIG_CALL_SAVED_R7
	pop r7
#endif
#ifdef CONFIG_CALL_SAVED_R8
	pop r8
#endif
#ifdef CONFIG_CALL_SAVED_R9
	pop r9
#endif
#ifdef CONFIG_CALL_SAVED_R10
	pop r10
#endif
#ifdef CONFIG_CALL_SAVED_R11
	pop r11
#endif
#ifdef CONFIG_CALL_SAVED_R12
	pop r12
#endif
#ifdef CONFIG_CALL_SAVED_R13
	pop r13
#endif
#ifdef CONFIG_CALL_SAVED_R14
	pop r14
#endif
#ifdef CONFIG_CALL_SAVED_R15
	pop r15
#endif
#ifdef CONFIG_CALL_SAVED_R16
	pop r16
#endif
#ifdef CONFIG_CALL_SAVED_R17
	pop r17
#endif
#ifdef CONFIG_CALL_SAVED_R18
	pop r18
#endif
#ifdef CONFIG_CALL_SAVED_R19
	pop r19
#endif
#ifdef CONFIG_CALL_SAVED_R20
	pop r20
#endif
#ifdef CONFIG_CALL_SAVED_R21
	pop r21
#endif
#ifdef CONFIG_CALL_SAVED_R22
	pop r22
#endif
#ifdef CONFIG_CALL_SAVED_R23
	pop r23
#endif
#ifdef CONFIG_CALL_SAVED_R24
	pop r24
#endif
#ifdef CONFIG_CALL_SAVED_R25
	pop r25
#endif
#ifdef CONFIG_CALL_SAVED_R26
	pop r26
#endif
#ifdef CONFIG_CALL_SAVED_R27
	pop r27
#endif
#ifdef CONFIG_CALL_SAVED_R28
	pop r28
#endif
#ifdef CONFIG_CALL_SAVED_R29
	pop r29
#endif
#ifdef CONFIG_CALL_SAVED_R30
	pop r30
#endif
#ifdef CONFIG_CALL_SAVED_R31
	pop r31
#endif
	ret
	.size	_taskSwitchTo, .-_taskSwitchTo
