// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2018-2019 Rupert Eibauer. All rights reserved.

#include <linux/sched.h>

#include <asm/system.h>
#include <asm/limits.h>

/* FIXME: This should be defined somewhere else! */

#ifdef CONFIG_NO_IRQ
__attribute__ ((naked, used, section (".vectors")))
#else
__attribute__ ((naked, used, section (".init0")))
#endif
void __init(void)
{
#ifdef CONFIG_NO_IRQ
	asm volatile ("cli"); /* Make sure at least one cli instruction exists in that whole system. */
#endif
	asm volatile ("clr __zero_reg__");
	asm volatile ("out __SREG__, r1");
	asm volatile ("ldi r28, %0" :: "i" ((RAM_END) & 0xff));
	asm volatile ("ldi r29, %0" :: "i" ((RAM_END) >> 8));
	asm volatile ("out __SP_H__, r29");
	asm volatile ("out __SP_L__, r28");
}

/* Create a dummy main, in case the application does not provide one. */
extern int main(void);


__attribute__ ((naked, used, section (".init9")))
void __call_main(void) {
#ifndef CONFIG_SCHEDULER
#ifdef CONFIG_MAIN_FUNCTION
	main();
#endif
	local_irq_enable();
	for (;;);
#else
	kill_current();
#endif
}

