/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) 2018-2019 Rupert Eibauer. All rights reserved. */

#include <asm/limits.h>
#include <asm/irqvec.h>

#if FLASH_END > 0x2000
#define _VECTOR_SIZE 4
#else
#define _VECTOR_SIZE 2
#endif

#if _VECTOR_SIZE == 4
#define XCALL call
#else
#define XCALL rcall
#endif

#if defined(CONFIG_CALL_USED_R18) && defined(CONFIG_CALL_USED_R19)

#define ret_r0 r18
#define ret_r1 r19
#undef CONFIG_CALL_USED_R18
#undef CONFIG_CALL_USED_R19

#elif defined(CONFIG_CALL_USED_R16) && defined(CONFIG_CALL_USED_R17)

#define ret_r0 r16
#define ret_r1 r17
#undef CONFIG_CALL_USED_R16
#undef CONFIG_CALL_USED_R17

#elif defined(CONFIG_CALL_USED_R20) && defined(CONFIG_CALL_USED_R21)

#define ret_r0 r20
#define ret_r1 r21
#undef CONFIG_CALL_USED_R20
#undef CONFIG_CALL_USED_R21

#elif defined(CONFIG_CALL_USED_R22) && defined(CONFIG_CALL_USED_R23)

#define ret_r0 r22
#define ret_r1 r23
#undef CONFIG_CALL_USED_R22
#undef CONFIG_CALL_USED_R23

#else

#error Need to select another register

#endif

#if 0
#elif defined(CONFIG_CALL_USED_R30) && defined(CONFIG_CALL_USED_R31)
#define PTR Z
#define PTR_lo r30
#define PTR_hi r31
#elif defined(CONFIG_CALL_USED_R28) && defined(CONFIG_CALL_USED_R29)
#define PTR Y
#define PTR_lo r28
#define PTR_hi r29
#elif defined(CONFIG_CALL_USED_R26) && defined(CONFIG_CALL_USED_R27)
#define PTR X
#define PTR_lo r26
#define PTR_hi r27
#define PTR_IS_X
#warning Using pointer X from CALL_USED
#elif !defined(RESERVED_R30) && !defined(RESERVED_R31)
#define PTR Z
#define PTR_lo r30
#define PTR_hi r31
#define CONFIG_CALL_USED_R30 2
#define CONFIG_CALL_USED_R31 2
#elif !defined(RESERVED_R28) && !defined(RESERVED_R29)
#define PTR Y
#define PTR_lo r28
#define PTR_hi r29
#define CONFIG_CALL_USED_R28 2
#define CONFIG_CALL_USED_R29 2
#elif !defined(RESERVED_R26) && !defined(RESERVED_R27)
#define PTR X
#define PTR_lo r26
#define PTR_hi r27
#define CONFIG_CALL_USED_R26 2
#define CONFIG_CALL_USED_R27 2
#define PTR_IS_X
#warning Using pointer X from CALL_SAVED
#else
#error NO Pointer registers are available!
#endif

/* We need R24 and R25 as argument for do_IRQ */
#ifndef CONFIG_CALL_USED_R24
#define CONFIG_CALL_USED_R24 1
#endif
#if NR_IRQS > 126
#ifndef CONFIG_CALL_USED_R25
#define CONFIG_CALL_USED_R25 1
#endif
#endif

#include "used-regs-counter.h"

	.file	"head.S"
__SP_H__ = 0x3e
__SP_L__ = 0x3d
__SREG__ = 0x3f
__tmp_reg__ = 0
__zero_reg__ = 1
	.section .vectors,"ax",@progbits
	.global	__vectors
	.func	__vectors
__vectors:
#include <generated/vectable.h>
	.endfunc

#ifndef CONFIG_IRQ_CLASSIC
/* This is our main interrupt handler.
   It does save all required registers and gets the return address. */
	.text
.global	__irqentry
	.type	__irqentry, @function
__irqentry:
	push r1
	push r0
	in r0,__SREG__
	push r0
	clr __zero_reg__
#ifdef CONFIG_CALL_USED_R2
	push r2
#endif
#ifdef CONFIG_CALL_USED_R3
	push r3
#endif
#ifdef CONFIG_CALL_USED_R4
	push r4
#endif
#ifdef CONFIG_CALL_USED_R5
	push r5
#endif
#ifdef CONFIG_CALL_USED_R6
	push r6
#endif
#ifdef CONFIG_CALL_USED_R7
	push r7
#endif
#ifdef CONFIG_CALL_USED_R8
	push r8
#endif
#ifdef CONFIG_CALL_USED_R9
	push r9
#endif
#ifdef CONFIG_CALL_USED_R10
	push r10
#endif
#ifdef CONFIG_CALL_USED_R11
	push r11
#endif
#ifdef CONFIG_CALL_USED_R12
	push r12
#endif
#ifdef CONFIG_CALL_USED_R13
	push r13
#endif
#ifdef CONFIG_CALL_USED_R14
	push r14
#endif
#ifdef CONFIG_CALL_USED_R15
	push r15
#endif
#ifdef CONFIG_CALL_USED_R16
	push r16
#endif
#ifdef CONFIG_CALL_USED_R17
	push r17
#endif
#ifdef CONFIG_CALL_USED_R18
	push r18
#endif
#ifdef CONFIG_CALL_USED_R19
	push r19
#endif
#ifdef CONFIG_CALL_USED_R20
	push r20
#endif
#ifdef CONFIG_CALL_USED_R21
	push r21
#endif
#ifdef CONFIG_CALL_USED_R22
	push r22
#endif
#ifdef CONFIG_CALL_USED_R23
	push r23
#endif
#ifdef CONFIG_CALL_USED_R24
	push r24
#endif
#ifdef CONFIG_CALL_USED_R25
	push r25
#endif
#ifdef CONFIG_CALL_USED_R26
	push r26
#endif
#ifdef CONFIG_CALL_USED_R27
	push r27
#endif
#ifdef CONFIG_CALL_USED_R28
	push r28
#endif
#ifdef CONFIG_CALL_USED_R29
	push r29
#endif
#ifdef CONFIG_CALL_USED_R30
	push r30
#endif
#ifdef CONFIG_CALL_USED_R31
	push r31
#endif

	in PTR_lo,__SP_L__
	in PTR_hi,__SP_H__
.L__stack_usage = NR_USED_REGS+4
	/* Load the vector address stored by the call in the vector table into r24:r25 */
#ifdef PTR_IS_X

#if NR_IRQS > 126
	adiw PTR_lo, NR_USED_REGS+4
	ld r25, PTR+
#else
	adiw PTR_lo, NR_USED_REGS+5
#endif
	ld r24, PTR
	/* Overwrite the return address with r18 and r19, to pop it later. icky. */
	st PTR, ret_r0
	st -PTR, ret_r1

#else /* PTR_IS_X */

#if NR_IRQS > 126
	ldd r25, PTR+NR_USED_REGS+4
#endif
	ldd r24, PTR+NR_USED_REGS+5
	/* Overwrite the return address with r18 and r19, to pop it later. icky. */
	std PTR+NR_USED_REGS+4, ret_r1
	std PTR+NR_USED_REGS+5, ret_r0

#endif /* PTR_IS_X */
	/* The address saved by the call in the vector table is (vector + 1) * _VECTOR_SIZE */
	/* we get the vector by calculating addr / (_VECTOR_SIZE / 2) - 1 */
#if _VECTOR_SIZE == 4
#if NR_IRQS > 126
	lsr r25
	ror r24
#else
	lsr r24
#endif
#endif
	dec r24
	XCALL do_IRQ

#ifdef CONFIG_CALL_USED_R31
	pop r31
#endif
#ifdef CONFIG_CALL_USED_R30
	pop r30
#endif
#ifdef CONFIG_CALL_USED_R29
	pop r29
#endif
#ifdef CONFIG_CALL_USED_R28
	pop r28
#endif
#ifdef CONFIG_CALL_USED_R27
	pop r27
#endif
#ifdef CONFIG_CALL_USED_R26
	pop r26
#endif
#ifdef CONFIG_CALL_USED_R25
	pop r25
#endif
#ifdef CONFIG_CALL_USED_R24
	pop r24
#endif
#ifdef CONFIG_CALL_USED_R23
	pop r23
#endif
#ifdef CONFIG_CALL_USED_R22
	pop r22
#endif
#ifdef CONFIG_CALL_USED_R21
	pop r21
#endif
#ifdef CONFIG_CALL_USED_R20
	pop r20
#endif
#ifdef CONFIG_CALL_USED_R19
	pop r19
#endif
#ifdef CONFIG_CALL_USED_R18
	pop r18
#endif
#ifdef CONFIG_CALL_USED_R17
	pop r17
#endif
#ifdef CONFIG_CALL_USED_R16
	pop r16
#endif
#ifdef CONFIG_CALL_USED_R15
	pop r15
#endif
#ifdef CONFIG_CALL_USED_R14
	pop r14
#endif
#ifdef CONFIG_CALL_USED_R13
	pop r13
#endif
#ifdef CONFIG_CALL_USED_R12
	pop r12
#endif
#ifdef CONFIG_CALL_USED_R11
	pop r11
#endif
#ifdef CONFIG_CALL_USED_R10
	pop r10
#endif
#ifdef CONFIG_CALL_USED_R9
	pop r9
#endif
#ifdef CONFIG_CALL_USED_R8
	pop r8
#endif
#ifdef CONFIG_CALL_USED_R7
	pop r7
#endif
#ifdef CONFIG_CALL_USED_R6
	pop r6
#endif
#ifdef CONFIG_CALL_USED_R5
	pop r5
#endif
#ifdef CONFIG_CALL_USED_R4
	pop r4
#endif
#ifdef CONFIG_CALL_USED_R3
	pop r3
#endif
#ifdef CONFIG_CALL_USED_R2
	pop r2
#endif

	pop r0
	out __SREG__,r0
	pop r0
	pop r1
	pop ret_r1
	pop ret_r0
	reti
	.size	__irqentry, .-__irqentry
#endif