/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_TIMER_H
#define _ASM_TIMER_H

/* The following function is to be provided by arch code and
   is called when the expiring timer changes. */
#ifdef CONFIG_DYNAMIC_TICK
void _update_timer(void);
#else
static inline void _update_timer(void) { }
#endif

#ifdef CONFIG_DYNAMIC_TICK

extern jiffies_t get_jiffies(void);
#define jiffies get_jiffies()

#ifdef CONFIG_PRESCALE1024
#define HZ ((jiffies_t)CONFIG_CPUFREQ/1024)
#elif defined(CONFIG_PRESCALE256)
#define HZ ((jiffies_t)CONFIG_CPUFREQ/256)
#elif defined(CONFIG_PRESCALE64)
#define HZ ((jiffies_t)CONFIG_CPUFREQ/64)
#elif defined(CONFIG_PRESCALE8)
#define HZ ((jiffies_t)CONFIG_CPUFREQ/8)
#endif

#else /* CONFIG_DYNAMIC_TICK */

extern volatile jiffies_t jiffies;
#define HZ ((jiffies_t)CONFIG_HZ)

#endif /* CONFIG_DYNAMIC_TICK */

#endif /* _ASM_TIMER_H */
