/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_AVR_STRING_H
#define _ASM_AVR_STRING_H

#include <linux/types.h>

#if MEMOP_SIZE_T_BITS == 8

static inline u8 strlen(char const *str) {
	char const *ret = str;
	u8 low = (u8)(uintptr_t)str;
	asm (
		"1:\n\t"
		"ld r0, %a0+\n\t"
		"tst r0\n\t"
		"brne 1b\n\t"
		"sub %0, %1\n\t"
		: "+&e" (ret)
		: "r" (low)
		:
	);
	return (u8)(uintptr_t)ret - 1;
}
#define strlen strlen

#endif /* MEMOP_SIZE_T_BITS == 8 */

#endif /* _ASM_AVR_STRING_H */
