/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_AVR_FLASH_H
#define _ASM_AVR_FLASH_H

#include <linux/types.h>
#include <asm/limits.h>

#if FLASH_END < (1UL << 16)
#define flash_addr_t u16
#elif (FLASH_END < (1UL << 24))
#define flash_addr_t u24
#else
#define flash_addr_t u32
#endif

#if (FLASH_END / FLASH_PAGESIZE) < (1UL << 16)
#define flash_page_t u16
#elif (FLASH_END / FLASH_PAGESIZE) < (1UL << 24)
#define flash_page_t u24
#else
#define flash_page_t u32
#endif

#define flash_read8_inc(ip) ({ \
        u8 ret; \
        asm ( \
                "lpm %0, %a1+" \
                : "=r" (ret), "+z" (ip) \
                : "1" (ip) \
        ); \
        ret; \
})

#define flash_read16_inc(ip) ({ \
        u16 ret; \
        asm ( \
                "lpm %A0, %a1+" \
                "lpm %B0, %a1+" \
                : "=r" (ret), "+z" (ip) \
                : "1" (ip) \
        ); \
        ret; \
})

#endif /* _ASM_AVR_FLASH_H */
