// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2020 Rupert Eibauer. All rights reserved.

#include <linux/init.h>
#include <asm/gpio.h>
#include <linux/delay.h>
#include <linux/timer.h>

#ifdef CONFIG_APP_HEARTBEAT_PORTA

#define HEARTBEAT_GPIO CONCATENATE(GPIO_A, CONFIG_APP_HEARTBEAT_PIN)

#elif defined(CONFIG_APP_HEARTBEAT_PORTB)

#define HEARTBEAT_GPIO CONCATENATE(GPIO_B, CONFIG_APP_HEARTBEAT_PIN)

#elif defined(CONFIG_APP_HEARTBEAT_PORTC)

#define HEARTBEAT_GPIO CONCATENATE(GPIO_C, CONFIG_APP_HEARTBEAT_PIN)

#elif defined(CONFIG_APP_HEARTBEAT_PORTD)

#define HEARTBEAT_GPIO CONCATENATE(GPIO_D, CONFIG_APP_HEARTBEAT_PIN)

#endif

static struct timer heartbeat_timer;

static void timer_on(struct timer *timer);
static void timer_off(struct timer *timer);
static struct timer heartbeat_timer = {
	.function = timer_on,
	.expires  = HZ * 2, // Starts 2 seconds after boot
};

static void timer_on(struct timer *timer) {
	gpio_out1(HEARTBEAT_GPIO);
	heartbeat_timer.expires += (HZ / 100);
	heartbeat_timer.function = timer_off;
	add_timer(&heartbeat_timer);
}

static void timer_off(struct timer *timer) {
	gpio_out0(HEARTBEAT_GPIO);
	heartbeat_timer.expires += HZ - (HZ / 100);
	heartbeat_timer.function = timer_on;
	add_timer(&heartbeat_timer);
}

static int init_heartbeat(void) {
	gpio_set_output(HEARTBEAT_GPIO);
	add_timer(&heartbeat_timer);
	return 0;
}
initcall(init_heartbeat);
