// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008, 2017-2019 Rupert Eibauer. All rights reserved.

#include <linux/init.h>
#include <linux/delay.h>
#include <linux/printk.h>
#include <linux/sched.h>

#include <asm/system.h>
#include <asm/io.h>

//#define NO_WAIT
#ifdef NO_WAIT

#define wait() do { } while(0)

#else /* NO_WAIT */
#define wait() udelay(500000)
#endif /* NO_WAIT */

/* Simple completion test */
/* The result should look like the following (when watched with simulavr-disp)
   PORTC alternating between 1 and 2
*/
// #define TEST_FAKE_IRQ

struct completion s;

#ifdef TEST_FAKE_IRQ
// void fake_irq_handler(void) __attribute__((signal));
void fake_irq_handler(void) {
	printk(KERN_NOTICE "irq\n");
	local_irq_disable();
	complete_from_irq(&s);
	resched_after_irq();
	local_irq_enable();
}
#endif


struct task_struct tw;
void fw(void *arg)
{
	printk(KERN_NOTICE "fw started\n");
	for (;;)
	{
		printk(KERN_NOTICE "fw\n");
		out(PORTC, 1);
		wait();
		wait_for_completion(&s);
	}
}
struct task_struct ts;
void fs(void *arg)
{
	printk(KERN_NOTICE "fs started\n");
	for (;;)
	{
		printk(KERN_NOTICE "fs\n");
		out(PORTC, 2);
		wait();
#ifdef TEST_FAKE_IRQ
		fake_irq_handler();
#else
		complete(&s);
#endif
	}
}

static int init_semaphore_test(void) {
	int i;
// 	out(DDRB, 0x3f);
	out(DDRC, 0x07);
	printk(KERN_NOTICE "in Main...\n");
	wait();
	wait();
	wait();
	wait();
	out(PORTC, 7);
	for (i = 0; i <= 7; i++) {
		wait();
		out(PORTC, i);
	}
	wait();
	out(PORTC, 0);

	kernel_thread(&tw, fw, NULL, 2); /* High-prio waiter */
	kernel_thread(&ts, fs, NULL, 1); /* Low-prio signaler */
	out(PORTC, 1);
	printk(KERN_NOTICE "calling schedule...\n");
	return 0;
}

initcall(init_semaphore_test);
