<?php
// SPDX-License-Identifier: GPL-2.0
// Copyright (c) 2008 Rupert Eibauer. All rights reserved.

/* Output exactly one quadrant of sine */
//echo "static const unsigned char SINUS_QUADRANT1[91] = {\n";
if (count($argv) >= 2) {
	$range = $argv[1];
} else {
	$range = 255;
}
if (count($argv) >= 3) {
	$steps = $argv[2];
} else {
	$steps = 90;
}
if (count($argv) >= 4 && !strcmp($argv[3], "-diff")) {
	$steigung = 1;
} else {
	$steigung = 0;
}

$sinus = 0;
for ($i = 0; $i <= $steps; $i++) {
	$sinus = round(sin($i / ($steps * 2) * 3.141592653589793238) * $range);
	if ($steigung) {
		if ($i == 0) {
			printf("/* f(   0) */ %2d,\n", $sinus);
		} else {
			$last_diff = $diff;
			$diff = $sinus - $last_sinus;
			if ($i == 1) {
				printf("/* f'(  1) */ %2d,\n", $sinus - $last_sinus);
				$diff = $sinus - $last_sinus;
			} else { // $i == 2
				printf("/* f''(%2d) */ %2d, /* %d = %d + %d */\n", $i, $diff - $last_diff, $sinus, $last_sinus, $sinus - $last_sinus);
			}
		}
		$last_sinus = $sinus;
	} else {
		printf("/* %2d */  %3d,\n", $i, $sinus);
	}
}
//echo "}\n";

?>