/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) 2008, 2018-2019 Rupert Eibauer. All rights reserved. */

/* SREG_OFFSET Must be 0! Otherwise we need a different instruction
to access it! */

#ifdef SCHED_SAVE_SREG
#define SREG_OFFSET  0
#define SP_OFFSET    1
#else
#define SP_OFFSET    0
#endif


#ifndef CONFIG_LARGE_SP

#ifdef CONFIG_TIME_SLICES
#define OVERHEAD_TIME_SLICES 1
#else
#define OVERHEAD_TIME_SLICES 0
#endif

#ifdef CONFIG_MUTEX_PI
#define OVERHEAD_MUTEX_PI 2
#else
#define OVERHEAD_MUTEX_PI 0
#endif

#ifdef CONFIG_SCHED_OTHER
#define OVERHEAD_SCHED_OTHER 7
#else
#define OVERHEAD_SCHED_OTHER 0
#endif


#define STACK_OFFSET (5 + CONFIG_STACK_GUARD + \
	OVERHEAD_TIME_SLICES + \
	OVERHEAD_MUTEX_PI + \
	OVERHEAD_SCHED_OTHER)

#endif /* CONFIG_LARGE_SP */


	.file	"sched.S"
__SREG__ = 0x3f
__SP_H__ = 0x3e
__SP_L__ = 0x3d
__tmp_reg__ = 0
__zero_reg__ = 1
.global	_taskSwitchTo
	.type	_taskSwitchTo, @function
_taskSwitchTo:

	push r17
	push r16
	push r15
	push r14
	push r13
	push r12
	push r11
	push r10
	push r9
	push r8
	push r7
	push r6
	push r5
	push r4
	push r3
	push r2
	push r29
	push r28

#if (__AVR_ARCH__ < 5)
	mov r28,r24
	mov r29,r25
#else
	movw r28,r24
#endif

	lds r30,current
	lds r31,(current)+1
	sbiw r30,0 /* if current is NULL */
	breq .L3  /* We skip saving regs */

/* Save the old SREG */
#ifdef SCHED_SAVE_SREG
	in r24,__SREG__
	std Z+SREG_OFFSET,r24
#endif

/* Save the old SP */
	in r24,__SP_L__
#ifdef CONFIG_LARGE_SP
	in r25,__SP_H__
	std Z+SP_OFFSET+1,r25
#else
	sub  r24,r30
	subi r24,STACK_OFFSET
#endif
	std Z+SP_OFFSET,r24

.L3: /*no_regs_save: */

/* Now, we save the new task to current */
	sts (current)+1,r29
	sts current,r28

/* Load the new SP */
#ifdef CONFIG_LARGE_SP
	ldd r24,Y+SP_OFFSET
	ldd r25,Y+SP_OFFSET+1
#else
#if (__AVR_ARCH__ < 5)
	mov r24,r28
	mov r25,r29
#else
	movw r24,r28
#endif
#if STACK_OFFSET > 63
	subi r24,lo8(-(STACK_OFFSET))
	sbci r25,hi8(-(STACK_OFFSET))
#else
	adiw r24, STACK_OFFSET
#endif
	ldd r18,Y+SP_OFFSET
	add r24,r18
	adc r25,__zero_reg__
#endif
	out __SP_H__,r25
	out __SP_L__,r24
/* Load the new SREG */
#ifdef SCHED_SAVE_SREG
	ldd r24,Y+SREG_OFFSET
	out __SREG__,r24
#endif

/* #APP */
	pop r28
	pop r29
	pop r2
	pop r3
	pop r4
	pop r5
	pop r6
	pop r7
	pop r8
	pop r9
	pop r10
	pop r11
	pop r12
	pop r13
	pop r14
	pop r15
	pop r16
	pop r17
/* #NOAPP */
/* epilogue: frame size=0 */
	ret
/* epilogue end (size=1) */
/* function _taskSwitchTo size 89 (88) */
	.size	_taskSwitchTo, .-_taskSwitchTo
