/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_AVR_FLASH_H
#define _ASM_AVR_FLASH_H

#include <linux/types.h>
#include <asm/limits.h>

#if FLASH_END < (1UL << 16)
#define flash_addr_t u16
#elif (FLASH_END < (1UL << 24))
#define flash_addr_t u24
#else
#define flash_addr_t u32
#endif

#if (FLASH_END / FLASH_PAGESIZE) < (1UL << 16)
#define flash_page_t u16
#elif (FLASH_END / FLASH_PAGESIZE) < (1UL << 24)
#define flash_page_t u24
#else
#define flash_page_t u32
#endif

/* This is for variable declarations (pointers in programs) */
#define __flashp_decl(x) const x __attribute__((progmem))
#define __flashp(x)    const __flash x
/* This is for data definitions data */
#define __flashdata_decl const __attribute__((progmem))
#define __flashdata  const  __flash

/* When you want to use it to dereference it , use __flashp_use(*),
 * When you want to use it to initialize it at compile time,
 *  use __flashp_decl(*)
 * This means that in every c file we have to define
 * #define __flashp_structname(x)
 * in the c file which includes the structure def.
 * and we have to use different c files to use and to initialize.
 * 
 */

#define FSTR(s) ({static char __flashdata_decl __fstr[] = (s); __fstr;})
// #define FMTSTR FSTR
#define FMTSTR(s) ({static char __flashdata_decl __fmtstr[] = (s); __fmtstr;})

/* This is not nice, but is the easiest way to silence the compiler warning about
   %S, which means something different on AVR */

#define F_PFARG(arg)   ((__WCHAR_TYPE__*)arg)

/* usage: __flashp(*) */
/* FIXME: Define our own section which is not copied in __do_copy_data,
 * (and the .data part discarded at link time)
 * Then we don't have any warnings and must copy it by hand, but at least we
 * don't have to mess with the broken __attribute__((progmem)) and __flash!
 */

#define flash_read(x)  (*(typeof(x) __flashp(*))&(x))
#define flash_read8_inc(ip) ({ \
        u8 ret; \
        asm ( \
                "lpm %0, %a1+" \
                : "=r" (ret), "+z" (ip) \
                : "1" (ip) \
        ); \
        ret; \
})
#define flash_read16_inc(ip) ({ \
        u16 ret; \
        asm ( \
                "lpm %A0, %a1+" \
                "lpm %B0, %a1+" \
                : "=r" (ret), "+z" (ip) \
                : "1" (ip) \
        ); \
        ret; \
})

#endif /* _ASM_AVR_FLASH_H */
