/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __LINUX_SCHED_H
#define __LINUX_SCHED_H

#include <linux/types.h>

#define CONFIG_KTHREAD_ARG
// #define CONFIG_END_TASK

#ifdef CONFIG_SCHEDULER

#include <asm/sched.h>

struct sched_entity {
	u8 prio;
#ifdef CONFIG_TIME_SLICES
	u8 timeSlice;
#endif
#ifdef CONFIG_SCHED_OTHER
	u8 weight;
	u8 bonus;
	struct task_struct *next_other; /* fixme: why not use task->next? */
	u8 exec_start;
#endif
};

struct task_struct {
	struct task_saved_state state; // CPU-specific state
	struct task_struct *next;
	struct sched_entity entity;
#ifdef CONFIG_MUTEX_PI
	struct mutex *waitMutex; // Mutex this task is blocked by
#endif
	/* FIMXE: stack_buffer1 and stack_buffer2 needed! */
	u8 stack_guard1[CONFIG_STACK_GUARD];
	u8 stack[CONFIG_STACK_SIZE];
	u8 stack_guard2[CONFIG_STACK_GUARD];
	
};

// create task & add to task-list
struct task_struct *kernel_thread(struct task_struct *task, void (*f)(void *arg), void *arg, signed char prio);

/* internal function to set-up the kickstart of the task. */
void setup_task(struct task_struct *task, void (*f)(void *arg), void *arg);

// trigger a task switch
// if called from the main thread it starts the scheduler
void schedule(void);

#ifdef CONFIG_USE_SEMA
struct completion {
	struct task_struct *waitTask;
	signed char done;
};

void complete(struct completion *s);
void wait_for_completion(struct completion *s);
#endif

#ifdef CONFIG_USE_MUTEX
struct mutex {
	struct task_struct *owner;
#ifdef CONFIG_MUTEX_PI
	u8 origPrio;
#endif
	struct task_struct *waiters;
};

void mutex_lock(struct mutex *mutex);
void mutex_unlock(struct mutex *mutex);
#endif

#ifdef CONFIG_USE_CHANGE_PRIO
void taskChangePrio(struct task_struct *task, u8 prio);
#endif

#endif /* CONFIG_SCHEDULER */

#ifdef CONFIG_WAKE_SEMA_FROM_IRQ
void complete_from_irq(struct completion *s);
void resched_after_irq(void);
#else
#define resched_after_irq() do{}while(0)
#endif

#define cond_resched() do{}while(0)

extern struct task_struct *current;

#ifdef CONFIG_STACK_SIZE_REPORTING
#define check_thread_stack(t) _check_thread_stack(t, __builtin_return_address(0), __LINE__)
#define check_thread_stack2(t, line) _check_thread_stack(t, __builtin_return_address(0), line + __LINE__)
extern void _check_thread_stack(struct task_struct *task, void *ret, u16 line);
#else
#define check_thread_stack(t) do{}while(0)
#define check_thread_stack2(t, line) do{}while(0)
#endif


#endif /* __LINUX_SCHED_H */
