/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_KERNEL_H
#define _LINUX_KERNEL_H

#include <linux/compiler.h>
#include <linux/types.h>

void _panic(void) __noreturn __cold;
#define panic(msg) _panic()

#ifndef __must_be_array
#define __must_be_array(x) 0 // should come from linux/compiler-gcc.h
#endif

/**
 * ARRAY_SIZE - get the number of elements in array @arr
 * @arr: array to be sized
 */
#define ARRAY_SIZE(arr) (sizeof(arr) / sizeof((arr)[0]) + __must_be_array(arr))

#endif /* _LINUX_KERNEL_H */
	