/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _LINUX_CDEV_H
#define _LINUX_CDEV_H

struct icdevbase {
	int (*getc_func)(struct icdevbase *dev);
};

struct ocdevbase {
	void (*putc_func)(struct ocdevbase *dev, char ch);
};

struct icdev {
	struct icdevbase in;
};
struct ocdev {
	struct ocdevbase out;
};

struct cdev {
	struct icdev in;
	struct ocdev out;
};

// #define offsetof_t(type, y)    ((long)&(   ((type)NULL)->y   )  )
// #define offsetof(x, y)         offsetof_t(typeof(x), y)
// #define upcast(ptr, type, member)  (type)((long)ptr - offsetof_t(type, member))

#define putc(dev, ch) oc_putc(&(dev)->out, ch)
#define getc(dev)     ic_getc(&(dev)->in)

extern int ic_getc(struct icdevbase *ic);
extern void oc_putc(struct ocdevbase *oc, char ch);


#endif /* _LINUX_CDEV_H */